import random

def generate_random_visible_char():
    all_visible_chars = ''.join(chr(i) for i in range(32, 127))
    return random.choice(all_visible_chars)

def generate_test_data():
    for i in range(10):
        char = generate_random_visible_char()
        height = 3
        base = 5
        half_base = (base - 1) // 2

        with open(f'triangle{i}.in', 'w') as in_file:
            in_file.write(char)

        # 写入输出文件（三角形本身，不包含输入）
        with open(f'triangle{i}.ans', 'w') as ans_file:
            for i in range(height):
                ans_file.write(' ' * (half_base - i) + char * (2 * i + 1) + ' ' * (half_base - i) + '\n')

generate_test_data()